package com.ejie.ab04b.exception;

import java.io.Serializable;

/**
 * Clase que encapsula la informacion para las excepciones controladas
 * 
 * @author GFI
 */
public class ErrorNoFeedbackException extends RuntimeException implements Serializable {

	private static final long serialVersionUID = 1L;

	private String errorCode = null;
	private String tiles = null;

	public static final String ERROR_CODE_SESSION_EXPIRED = "SESSION_EXPIRED";

	/**
	 * Instantiates a new error no feedback exception.
	 * 
	 *  errorCode            String
	 *  tiles            String
	 *
	 * @param errorCode the error code
	 * @param tiles the tiles
	 */
	public ErrorNoFeedbackException(String errorCode, String tiles) {
		super();
		this.errorCode = errorCode;
		this.tiles = tiles;
	}

	/**
	 * Gets the error code.
	 * 
	 *  the errorCode
	 *
	 * @return the error code
	 */
	public String getErrorCode() {
		return this.errorCode;
	}

	/**
	 * Method 'getTiles'.
	 * 
	 *  String
	 *
	 * @return the tiles
	 */
	public String getTiles() {
		return this.tiles;
	}

}